/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.worldgen.util;

import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeFactory {
    public static void addRandomMedium(WorldGenLevel world, BlockPos pos, BlockState block) {
        if (world.m_8055_(pos.m_7495_()).m_60734_() != BlockRegistry.ABYSMAL_FRONDS) {
            return;
        }
        switch (world.m_213780_().m_188503_(3)) {
            case 0: {
                TreeFactory.placeMediumDeadTree1(world, pos, block);
                break;
            }
            case 1: {
                TreeFactory.placeMediumDeadTree2(world, pos, block);
                break;
            }
            case 2: {
                TreeFactory.placeMediumDeadTree3(world, pos, block);
            }
        }
    }

    public static void placeSmallDeadTree(WorldGenLevel world, BlockPos pos, BlockState block) {
        if (world.m_8055_(pos.m_7495_()).m_60734_() != BlockRegistry.ABYSMAL_FRONDS) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (world.m_213780_().m_188499_() && i == 4) {
                world.m_7731_(pos.m_6630_(i), block, 3);
                break;
            }
            world.m_7731_(pos.m_6630_(i), block, 3);
        }
        world.m_7731_(TreeFactory.randomSouthNorth(pos.m_6630_(world.m_213780_().m_216332_(1, 2)), world), (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.SOUTH.m_122434_()), 3);
        if (world.m_213780_().m_188499_()) {
            world.m_7731_(TreeFactory.randomEastWest(pos.m_6630_(world.m_213780_().m_216332_(2, 3)), world), (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.EAST.m_122434_()), 3);
        }
    }

    public static void placeMediumDeadTree1(WorldGenLevel world, BlockPos pos, BlockState block) {
        if (world.m_8055_(pos.m_7495_()).m_60734_() != BlockRegistry.ABYSMAL_FRONDS) {
            return;
        }
        BlockPos[] branches_vertical = new BlockPos[]{pos.m_122019_().m_6630_(4), pos.m_122019_().m_122029_().m_6630_(5), pos.m_122019_().m_122029_().m_6630_(6), pos.m_122025_(2).m_6630_(5), pos.m_122025_(2).m_6630_(6), pos.m_122025_(2).m_6630_(7), pos.m_122013_(2).m_122029_().m_6630_(3), pos.m_122013_(2).m_122029_().m_6630_(4)};
        for (int i = 0; i < 4; ++i) {
            world.m_7731_(pos.m_6630_(i), block, 3);
        }
        TreeFactory.placeVerticalBranches(branches_vertical, world, block, BlockRegistry.PRIMORDIAL_LEAVES.m_49966_());
        world.m_7731_(pos.m_122012_().m_6630_(2), (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.NORTH.m_122434_()), 3);
        world.m_7731_(pos.m_122019_().m_122024_().m_6630_(4), (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.WEST.m_122434_()), 3);
    }

    public static void placeMediumDeadTree2(WorldGenLevel world, BlockPos pos, BlockState block) {
        int i;
        if (world.m_8055_(pos.m_7495_()).m_60734_() != BlockRegistry.ABYSMAL_FRONDS) {
            return;
        }
        BlockPos[] branches_vertical = new BlockPos[]{pos.m_122029_().m_6630_(2), pos.m_122024_().m_6630_(2), pos.m_122024_().m_6630_(3), pos.m_122024_().m_6630_(4), pos.m_122024_().m_6630_(5), pos.m_122024_().m_6630_(6), pos.m_122020_(2).m_6630_(5), pos.m_122020_(2).m_6630_(6), pos.m_122020_(2).m_6630_(7), pos.m_122020_(2).m_6630_(8)};
        BlockPos[] branches_horizontal_ns = new BlockPos[]{pos.m_122012_().m_122024_().m_6630_(4), pos.m_122019_().m_122024_().m_6630_(4), pos.m_122020_(2).m_122024_().m_6630_(4)};
        BlockPos[] fix_leaves = new BlockPos[]{pos.m_122013_(2).m_122024_().m_6630_(4), pos.m_122020_(2).m_122025_(2).m_6630_(4), pos.m_122020_(2).m_6630_(4), pos.m_122020_(2).m_122024_().m_6630_(3), pos.m_122020_(3).m_122024_().m_6630_(4)};
        for (i = 0; i < 2; ++i) {
            world.m_7731_(pos.m_6630_(i), block, 3);
        }
        if (Configs.Biome.PRIMORDIAL_ABYSS.enable_leaves_generation) {
            for (i = 0; i < fix_leaves.length; ++i) {
                world.m_7731_(fix_leaves[i], BlockRegistry.PRIMORDIAL_LEAVES.m_49966_(), 3);
            }
        }
        TreeFactory.placeVerticalBranches(branches_vertical, world, block, BlockRegistry.PRIMORDIAL_LEAVES.m_49966_());
        for (i = 0; i < branches_horizontal_ns.length; ++i) {
            world.m_7731_(branches_horizontal_ns[i], (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.SOUTH.m_122434_()), 3);
        }
    }

    public static void placeMediumDeadTree3(WorldGenLevel world, BlockPos pos, BlockState block) {
        int i;
        if (world.m_8055_(pos.m_7495_()).m_60734_() != BlockRegistry.ABYSMAL_FRONDS) {
            return;
        }
        BlockPos[] branches_vertical = new BlockPos[]{pos.m_122029_().m_6630_(4), pos.m_122029_().m_6630_(5), pos.m_122029_().m_6630_(6), pos.m_122029_().m_6630_(7), pos.m_122020_(2).m_122025_(2).m_6630_(3), pos.m_122020_(2).m_122025_(2).m_6630_(4), pos.m_122020_(2).m_122025_(2).m_6630_(5), pos.m_122013_(2).m_122024_().m_6630_(2), pos.m_122013_(2).m_122024_().m_6630_(3)};
        BlockPos[] branches_horizontal_ns = new BlockPos[]{pos.m_122012_().m_6630_(1), pos.m_122012_().m_122029_().m_6630_(5)};
        BlockPos[] branches_horizontal_ew = new BlockPos[]{pos.m_122019_().m_122024_().m_6630_(2), pos.m_122020_(2).m_122025_(3).m_6630_(4)};
        for (i = 0; i < 4; ++i) {
            world.m_7731_(pos.m_6630_(i), block, 3);
        }
        TreeFactory.placeVerticalBranches(branches_vertical, world, block, BlockRegistry.PRIMORDIAL_LEAVES.m_49966_());
        for (i = 0; i < branches_horizontal_ns.length; ++i) {
            world.m_7731_(branches_horizontal_ns[i], (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.SOUTH.m_122434_()), 3);
        }
        for (i = 0; i < branches_horizontal_ew.length; ++i) {
            world.m_7731_(branches_horizontal_ew[i], (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.EAST.m_122434_()), 3);
        }
    }

    public static void placeVerticalBranches(BlockPos[] positions, WorldGenLevel world, BlockState log, BlockState leaves) {
        int i;
        for (i = 0; i < positions.length; ++i) {
            world.m_7731_(positions[i], log, 3);
        }
        if (Configs.Biome.PRIMORDIAL_ABYSS.enable_leaves_generation) {
            for (i = 0; i < positions.length; ++i) {
                if (world.m_8055_(positions[i].m_7494_()).m_60713_(log.m_60734_())) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (!world.m_8055_(positions[i].m_7918_(x, 0, z)).m_60795_()) continue;
                            world.m_7731_(positions[i].m_7918_(x, 0, z), leaves, 3);
                        }
                    }
                    continue;
                }
                world.m_7731_(positions[i].m_122029_(), leaves, 3);
                world.m_7731_(positions[i].m_122024_(), leaves, 3);
                world.m_7731_(positions[i].m_122012_(), leaves, 3);
                world.m_7731_(positions[i].m_122019_(), leaves, 3);
                world.m_7731_(positions[i].m_6630_(1), leaves, 3);
            }
        }
    }

    public static BlockPos randomAny(BlockPos pos, WorldGenLevel world) {
        switch (world.m_213780_().m_188503_(4)) {
            case 0: {
                return pos.m_122029_();
            }
            case 1: {
                return pos.m_122024_();
            }
            case 2: {
                return pos.m_122012_();
            }
            case 3: {
                return pos.m_122019_();
            }
        }
        return pos;
    }

    public static BlockPos randomSouthNorth(BlockPos pos, WorldGenLevel world) {
        switch (world.m_213780_().m_188503_(2)) {
            case 0: {
                return pos.m_122012_();
            }
            case 1: {
                return pos.m_122019_();
            }
        }
        return pos;
    }

    public static BlockPos randomEastWest(BlockPos pos, WorldGenLevel world) {
        switch (world.m_213780_().m_188503_(2)) {
            case 0: {
                return pos.m_122029_();
            }
            case 1: {
                return pos.m_122024_();
            }
        }
        return pos;
    }
}

