/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elocindev.eldritch_end.registry.StructureRegistry;
import elocindev.eldritch_end.worldgen.structure.TreePoolGenerator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TreeGenerator
extends Structure {
    public static final Codec<TreeGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TreeGenerator.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, TreeGenerator::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public TreeGenerator(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        ChunkPos chunkPos = context.f_226628_();
        BlockPos origin = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional template = context.f_226625_().m_230407_(new ResourceLocation("eldritch_end", "primordial_tree_big/variation_1"));
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).m_163801_().m_123341_() / 2, ((StructureTemplate)template.get()).m_163801_().m_123342_() / 2, ((StructureTemplate)template.get()).m_163801_().m_123343_() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        BlockPos position = new BlockPos(origin.m_123341_(), startY, origin.m_123343_());
        mutable.m_122190_((Vec3i)position).m_122184_(-halfLengths.m_123341_(), 0, -halfLengths.m_123343_());
        BlockPos finalPos = new BlockPos(mutable.m_123341_(), context.f_226622_().m_223235_(mutable.m_123341_(), mutable.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), mutable.m_123343_());
        Optional<Structure.GenerationStub> structurePiecesGenerator = TreePoolGenerator.generate(context, this.startPool, this.startJigsawName, this.size, finalPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return StructureRegistry.ELDRITCH_END_TREES;
    }
}

