/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.entity.tentacle;

import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.effects.Corruption;
import elocindev.eldritch_end.entity.tentacle.UndeadTentacleEntity;
import elocindev.eldritch_end.registry.EffectRegistry;
import elocindev.eldritch_end.registry.EntityRegistry;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TentacleEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public TentacleEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.0, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_8055_(this.m_20183_().m_7495_()) == Blocks.f_50016_.m_49966_()) {
            this.m_6074_();
        }
        if (this.m_21023_(EffectRegistry.HASTUR_PRESENCE) && this instanceof TentacleEntity) {
            UndeadTentacleEntity tentacle = new UndeadTentacleEntity(EntityRegistry.UNDEAD_TENTACLE, this.m_9236_());
            tentacle.m_21153_(this.m_21223_());
            tentacle.m_20256_(this.m_20184_());
            tentacle.m_146884_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)tentacle);
            this.m_146870_();
            return;
        }
    }

    public void m_8107_() {
        this.m_9236_().m_46473_().m_6180_("ai");
        if (this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        } else if (this.m_21515_()) {
            this.m_9236_().m_46473_().m_6180_("newAi");
            this.m_6140_();
            this.m_9236_().m_46473_().m_7238_();
        }
    }

    public boolean m_7327_(Entity target) {
        if (target instanceof Player) {
            Player victim = (Player)target;
            MobEffect effect = EffectRegistry.CORRUPTION;
            if (victim.m_21023_(effect)) {
                victim.m_7292_(new MobEffectInstance(effect, victim.m_21124_(effect).m_19557_(), victim.m_21124_(effect).m_19564_() + 1, false, false));
                float extradamage = (float)Configs.Entity.ABERRATION.ATTACK_DAMAGE_ATTRIBUTE * 0.25f * (float)(victim.m_21124_(effect).m_19564_() + 1);
                victim.m_6469_(Corruption.of(this.m_9236_(), Corruption.DAMAGE), extradamage);
            } else {
                victim.m_7292_(new MobEffectInstance(effect, Configs.Entity.ABERRATION.initital_corruption_duration_ticks, 0, false, false));
            }
        }
        return super.m_7327_(target);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, Configs.Entity.TENTACLE.HEALTH_ATTRIBUTE).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, Configs.Entity.TENTACLE.ATTACK_DAMAGE_ATTRIBUTE).m_22268_(Attributes.f_22283_, Configs.Entity.TENTACLE.ATTACK_SPEED_ATTRIBUTE).m_22268_(Attributes.f_22278_, 100.0).m_22268_(Attributes.f_22277_, 2.0);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "animationPredicate", 10, event -> {
            if (this.f_19797_ < 20) {
                event.getController().setTransitionLength(0);
                event.getController().setAnimation(RawAnimation.begin().then("appear", Animation.LoopType.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            if (this.f_20911_) {
                this.f_20911_ = false;
                event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        })}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackAnimationPredicate", 10, event -> {
            if (this.m_5912_()) {
                event.getController().setAnimationSpeed(4.0);
                event.getController().forceAnimationReset();
                event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

