/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.api;

import elocindev.eldritch_end.block.dark_magic.pedestal.GreatSummoningPedestal;
import elocindev.eldritch_end.block.dark_magic.pedestal.LesserSummoningPedestal;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class RitualAPI {
    public static RitualStructure getRitualStructure(BlockPos center, Level world) {
        if (RitualAPI.isBasicRitual(center, world)) {
            return RitualStructure.BASIC;
        }
        return RitualStructure.INVALID;
    }

    public static boolean isBasicRitual(BlockPos center, Level world) {
        if (world.m_8055_(center).m_60734_() instanceof GreatSummoningPedestal) {
            int lesserPedestals = 0;
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (!(world.m_8055_(center.m_7918_(x, 0, z)).m_60734_() instanceof LesserSummoningPedestal)) continue;
                    ++lesserPedestals;
                }
            }
            if (lesserPedestals == 4) {
                return true;
            }
        }
        return false;
    }

    public static int getSummoningPower(BlockPos center, RitualStructure type, Level world, TagKey<Block> power_block, int power_per_block) {
        if (type == RitualStructure.BASIC) {
            int power = 0;
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (!world.m_8055_(center.m_7918_(x, 1, z)).m_204336_(power_block)) continue;
                    power = power_per_block;
                }
            }
            return power;
        }
        return 0;
    }

    public static enum RitualStructure {
        INVALID,
        BASIC;

    }

    public static enum RitualType {
        INVALID,
        SUMMONING;

    }
}

