/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import mod.chloeprime.aaaparticles.api.client.effekseer.EffekseerEffect;
import mod.chloeprime.aaaparticles.api.client.effekseer.TextureType;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.loader.EffekLoadException;
import mod.chloeprime.aaaparticles.client.registry.EffectDefinition;
import mod.chloeprime.aaaparticles.client.render.EffekRenderer;
import mod.chloeprime.aaaparticles.common.util.LimitlessResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffekAssetLoader
extends SimplePreparableReloadListener<Preparations> {
    private static EffekAssetLoader INSTANCE;
    private static final Logger LOGGER;
    private final Map<ResourceLocation, EffectDefinition> loadedEffects = new LinkedHashMap<ResourceLocation, EffectDefinition>();

    public static EffekAssetLoader get() {
        return INSTANCE;
    }

    @Nullable
    public EffectDefinition get(ResourceLocation id) {
        return this.loadedEffects.get(id);
    }

    public Set<Map.Entry<ResourceLocation, EffectDefinition>> entries() {
        return this.loadedEffects.entrySet();
    }

    public void forEach(BiConsumer<ResourceLocation, EffectDefinition> action) {
        this.loadedEffects.forEach(action);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<EffekseerEffect> loadEffect(ResourceManager manager, ResourceLocation name, Resource efkefc) {
        try (InputStream input = efkefc.m_215507_();){
            EffekseerEffect effect = new EffekseerEffect();
            boolean success = effect.load(input, 1.0f);
            if (!success) {
                LOGGER.error("Failed to load " + name);
                Optional<EffekseerEffect> optional2 = Optional.empty();
                return optional2;
            }
            for (TextureType texType : TextureType.values()) {
                int count = effect.textureCount(texType);
                this.load(manager, name, count, i -> effect.getTexturePath(i, texType), (b, len, i) -> effect.loadTexture((byte[])b, len, i, texType));
            }
            this.load(manager, name, effect.modelCount(), effect::getModelPath, effect::loadModel);
            this.load(manager, name, effect.curveCount(), effect::getCurvePath, effect::loadCurve);
            this.load(manager, name, effect.materialCount(), effect::getMaterialPath, effect::loadMaterial);
            Optional<EffekseerEffect> optional = Optional.of(effect);
            return optional;
        }
        catch (IOException ex2) {
            EffekAssetLoader.handleCheckedException(ex2);
            return Optional.empty();
        }
    }

    private void load(ResourceManager manager, ResourceLocation name, int count, IntFunction<String> pathGetter, TriConsumer<byte[]> loadMethod) throws IOException {
        String modid = name.m_135827_();
        for (int i = 0; i < count; ++i) {
            String effekAssetPath = pathGetter.apply(i);
            String mcAssetPath = ("effeks/" + effekAssetPath).replace('\\', '/').replace("//", "/");
            String fallbackMcAssetPath = ("effeks/" + name.m_135815_() + "/" + effekAssetPath).replace('\\', '/').replace("//", "/");
            LimitlessResourceLocation main = new LimitlessResourceLocation(modid, mcAssetPath);
            LimitlessResourceLocation fallback = new LimitlessResourceLocation(modid, fallbackMcAssetPath);
            Resource resource = EffekAssetLoader.getResourceOrUseFallbackPath(manager, main, fallback).orElseThrow(() -> new FileNotFoundException("Failed to load %s or %s".formatted(new Object[]{main, fallback})));
            try (InputStream input = resource.m_215507_();){
                byte[] bytes = IOUtils.toByteArray((InputStream)input);
                boolean success = loadMethod.accept(bytes, bytes.length, i);
                if (success) continue;
                String info = String.format("Failed to load effek data %s", effekAssetPath);
                LOGGER.debug(String.format("\n%s\nmc asset path is \"%s\"", info, mcAssetPath));
                throw new EffekLoadException(info);
            }
        }
    }

    private static Optional<Resource> getResourceOrUseFallbackPath(ResourceManager manager, ResourceLocation path, ResourceLocation fallback) {
        return manager.m_213713_(path).or(() -> manager.m_213713_(fallback));
    }

    private void unloadAll() {
        this.loadedEffects.forEach((? super K id, ? super V definition) -> definition.close());
        this.loadedEffects.clear();
    }

    @NotNull
    protected Preparations prepare(ResourceManager manager, ProfilerFiller profilerFiller) {
        return null;
    }

    private static ResourceLocation createEffekName(ResourceLocation location) {
        String filePath = location.m_135815_();
        if (filePath.startsWith("effeks/")) {
            filePath = filePath.substring("effeks/".length());
        }
        if (filePath.endsWith(".efkefc") || filePath.endsWith(".efkpkg")) {
            filePath = filePath.substring(0, filePath.length() - ".efkefc".length());
        }
        return new ResourceLocation(location.m_135827_(), filePath);
    }

    protected void apply(Preparations prep_, ResourceManager manager, ProfilerFiller profilerFiller) {
        EffekRenderer.init();
        if (!NativePlatform.isRunningOnUnsupportedPlatform()) {
            Preparations prep = new Preparations();
            manager.m_214159_("effeks", rl -> rl.m_135815_().endsWith(".efkefc")).forEach((? super K location, ? super V resource) -> {
                ResourceLocation name = EffekAssetLoader.createEffekName(location);
                this.loadEffect(manager, name, (Resource)resource).ifPresent(effect -> prep.loadedEffects.put(name, new EffectDefinition().setEffect((EffekseerEffect)effect)));
            });
            this.unloadAll();
            this.loadedEffects.putAll(prep.loadedEffects);
        }
        INSTANCE = this;
    }

    private static void handleCheckedException(Exception e) {
        throw new RuntimeException(e);
    }

    static {
        LOGGER = LogManager.getLogger((String)EffekAssetLoader.class.getSimpleName());
    }

    @FunctionalInterface
    private static interface TriConsumer<T> {
        public boolean accept(T var1, int var2, int var3);
    }

    protected static class Preparations {
        private final Map<ResourceLocation, EffectDefinition> loadedEffects = new LinkedHashMap<ResourceLocation, EffectDefinition>();

        protected Preparations() {
        }
    }
}

