/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.BiomeRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public abstract class BackgroundRendererMixin {
    @Inject(method={"applyFog"}, at={@At(value="TAIL")})
    private static void eldritch_end_applyFog(Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo ci) {
        if (!Configs.Client.CLIENT_CONFIG.enable_fog) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        ClientLevel world = client.f_91073_;
        if (world == null || client.f_91074_ == null || !camera.m_167685_().equals((Object)FogType.NONE)) {
            return;
        }
        if (world.m_204166_(camera.m_90588_()) == BiomeRegistry.PRIMORDIAL_ABYSS) {
            RenderSystem.setShaderFogStart((float)Mth.m_14179_((float)1.0f, (float)BackgroundRendererMixin.vanillaFogStart(viewDistance), (float)0.0f));
            RenderSystem.setShaderFogEnd((float)Mth.m_14179_((float)1.0f, (float)viewDistance, (float)(viewDistance / 3.0f)));
        }
    }

    private static float vanillaFogStart(float viewDistance) {
        float f = Mth.m_14036_((float)64.0f, (float)(viewDistance / 10.0f), (float)4.0f);
        return viewDistance - f;
    }
}

