/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.item.infusion_materials;

import elocindev.eldritch_end.api.RitualAPI;
import elocindev.eldritch_end.api.dark_magic.SummonPartItem;
import elocindev.eldritch_end.api.infusion.InfusableItemMaterial;
import elocindev.eldritch_end.api.infusion.InfusionAttributeHolder;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.AttributeRegistry;
import elocindev.eldritch_end.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class AberrationHeartItem
extends SummonPartItem
implements InfusableItemMaterial {
    public AberrationHeartItem(Item.Properties settings, RitualAPI.RitualStructure ritualStructure, Block mainSummonBlock, BlockState aftermathBlock, EntityType<?> summon, boolean shouldSpawnLightning, List<ResourceLocation> allowed_biomes) {
        super(settings, ritualStructure, mainSummonBlock, aftermathBlock, summon, shouldSpawnLightning, allowed_biomes);
    }

    @Override
    public List<InfusionAttributeHolder> getInfusionAttributes() {
        return List.of(new InfusionAttributeHolder(AttributeRegistry.CORRUPTION, 15.0, InfusionAttributeHolder.Presets.CORRUPTION));
    }

    @Override
    public Item getInfusionTemplate() {
        return ItemRegistry.CORRUPTION_INFUSION_TEMPLATE;
    }

    @Override
    public boolean applyToArmor() {
        return Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor;
    }

    @Override
    public boolean applyToWeapons() {
        return Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons;
    }

    @Override
    public List<String> canSwapInfusionTo() {
        return List.of("eldritch_end:aberration_limb", "eldritch_end:xal");
    }

    @Override
    public boolean getSummoningConditions(BlockPos pos, Level world) {
        int[][] positions = new int[][]{{-2, 0}, {2, 0}, {0, -2}, {0, 2}};
        ArrayList<BlockState> blocks = new ArrayList<BlockState>();
        for (int[] offset : positions) {
            int x = offset[0];
            int z = offset[1];
            BlockState state = world.m_8055_(pos.m_7918_(x, 1, z));
            if (state.m_60734_() != Blocks.f_152524_) {
                return false;
            }
            blocks.add(state);
        }
        Object object = blocks.iterator();
        while (object.hasNext()) {
            BlockState state = (BlockState)object.next();
            if (!(state.m_60734_() instanceof CandleBlock) || (Integer)state.m_61143_((Property)CandleBlock.f_152790_) == 4 || ((Boolean)state.m_61143_((Property)CandleBlock.f_152791_)).booleanValue()) continue;
            return false;
        }
        return RitualAPI.isBasicRitual(pos, world);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        String appliesto = Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor && Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons ? "infusion.eldritch_end.applies_to_all" : (Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor ? "infusion.eldritch_end.applies_to_armor" : "infusion.eldritch_end.applies_to_weapons");
        tooltip.add((Component)Component.m_237115_((String)"infusion.eldritch_end.infusable").m_7220_((Component)Component.m_237115_((String)appliesto)).m_130946_(" (Tier II)").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }
}

