/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.corruption;

import elocindev.eldritch_end.api.CorruptionAPI;
import elocindev.eldritch_end.config.entries.mechanics.CorruptionConfig;
import elocindev.eldritch_end.corruption.ClientCorruption;
import elocindev.eldritch_end.worldgen.util.TextUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CorruptionDisplayTooltip
extends Item {
    public CorruptionDisplayTooltip(Item.Properties settings) {
        super(settings);
    }

    public Component m_41466_() {
        return CorruptionAPI.getCMenuTitle();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (world == null || !world.m_5776_()) {
            return;
        }
        CorruptionConfig.CorruptionEffects effects = CorruptionAPI.CONFIG.corruption_effects;
        String effectKey = "eldritch_end.corruption.gui.effect.name.";
        boolean isShiftDown = Screen.m_96638_();
        if (isShiftDown) {
            effectKey = "eldritch_end.corruption.gui.effect.description.";
        }
        int resistance = ClientCorruption.getCorruptionResistanceLevel();
        int corruption = ClientCorruption.getTotalCorruptionLevel();
        Style descriptionStyle = Style.f_131099_.m_178520_(13197084);
        MutableComponent baseCorruption = Component.m_237113_((String)(" (" + ClientCorruption.getCorruptionLevel() + ")")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(true)));
        if (resistance == 0 || !isShiftDown) {
            baseCorruption = Component.m_237119_();
        }
        MutableComponent resistText = Component.m_237113_((String)"\uab01 ").m_7220_((Component)Component.m_237113_((String)(resistance + " Corruption Resistance")).m_6270_(TextUtils.Styles.CORRUPTION_RESISTANCE));
        MutableComponent corruptionText = Component.m_237113_((String)"\ua999 ").m_7220_((Component)Component.m_237113_((String)(ClientCorruption.getCorruptionLevel() + " Corruption")).m_6270_(TextUtils.Styles.DAMAGE_CORRUPTION));
        MutableComponent totalCorruptionText = Component.m_237113_((String)"\ua999 ").m_7220_((Component)Component.m_237113_((String)(corruption + " Affected Corruption")).m_6270_(TextUtils.Styles.DAMAGE_CORRUPTION).m_7220_((Component)baseCorruption));
        tooltip.add((Component)Component.m_237115_((String)"eldritch_end.corruption.gui.desc.1").m_6270_(descriptionStyle));
        tooltip.add((Component)Component.m_237115_((String)"eldritch_end.corruption.gui.desc.2").m_6270_(descriptionStyle));
        tooltip.add(CorruptionDisplayTooltip.newLine());
        tooltip.add((Component)resistText);
        tooltip.add((Component)corruptionText);
        tooltip.add(CorruptionDisplayTooltip.newLine());
        tooltip.add((Component)totalCorruptionText);
        tooltip.add(CorruptionDisplayTooltip.newLine());
        ArrayList<Tuple> effectsList = new ArrayList<Tuple>();
        effectsList.add(new Tuple((Object)(effectKey + "1"), (Object)effects.received_damage_increment.getStartingLevel()));
        effectsList.add(new Tuple((Object)(effectKey + "2"), (Object)effects.tentacle_spawn.getStartingLevel()));
        effectsList.add(new Tuple((Object)(effectKey + "3"), (Object)effects.madness_vision.getStartingLevel()));
        effectsList.add(new Tuple((Object)(effectKey + "4"), (Object)effects.non_corruption_damage_reduction.getStartingLevel()));
        effectsList.add(new Tuple((Object)(effectKey + "5"), (Object)effects.ominous_eye_spawn.getStartingLevel()));
        effectsList.add(new Tuple((Object)(effectKey + "6"), (Object)effects.madness_consumed.getStartingLevel()));
        effectsList.sort(Comparator.comparingInt(Tuple::m_14419_));
        for (Tuple effect : effectsList) {
            CorruptionDisplayTooltip.addCorruptionEffect(tooltip, (String)effect.m_14418_(), corruption, (Integer)effect.m_14419_());
        }
        tooltip.add(CorruptionDisplayTooltip.newLine());
        if (!isShiftDown) {
            tooltip.add((Component)Component.m_237115_((String)"eldritch_end.corruption.gui.shift").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        } else {
            tooltip.add(CorruptionDisplayTooltip.newLine());
        }
    }

    public static void addCorruptionEffect(List<Component> tooltip, String translationKey, int currentCorruptionLevel, int effectThreshold) {
        if (effectThreshold == -1) {
            return;
        }
        TextColor color = currentCorruptionLevel >= effectThreshold ? TextUtils.Styles.DAMAGE_CORRUPTION.m_131135_() : TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_GRAY);
        MutableComponent translatedText = Component.m_237115_((String)translationKey);
        translatedText = CorruptionDisplayTooltip.handleClientsidePlaceholders(translatedText, effectThreshold);
        tooltip.add((Component)translatedText.m_6270_(Style.f_131099_.m_131148_(color)));
    }

    public static MutableComponent handleClientsidePlaceholders(MutableComponent text, int effectThreshold) {
        CorruptionConfig.CorruptionEffects effects = CorruptionAPI.CONFIG.corruption_effects;
        String placeholders = text.getString().replace("%COST%", (CharSequence)(effectThreshold < 100 ? " " + String.valueOf(effectThreshold) : String.valueOf(effectThreshold))).replace("%CORRUPTION%", String.valueOf(ClientCorruption.getCorruptionLevel())).replace("%CORRUPTION_RESISTANCE%", String.valueOf(ClientCorruption.getCorruptionResistanceLevel())).replace("%TAKEN_DAMAGE%", effects.received_damage_increment.getStartingLevel() + "%").replace("%TENTACLE_CHANCE%", Math.round(effects.tentacle_spawn.getSpawnChance() * 100.0f) + "%").replace("%TENTACLE_UPDATE_RATE%", "" + effects.tentacle_spawn.getEffectRateSeconds()).replace("%DAMAGE_REDUCTION%", 100 - Math.round(effects.non_corruption_damage_reduction.getDamagePercentage() * 100.0f) + "%").replace("%EYES_TENTACLE_RATE%", "" + effects.ominous_eye_spawn.getEffectRateSeconds()).replace("%EYES_CHANCE%", Math.round(effects.ominous_eye_spawn.getSpawnChance() * 100.0f) + "%").replace("%MADNESS_DAMAGE%", Math.round(effects.madness_consumed.getMaxHealthPerSecond() * 100.0f) + "%");
        return Component.m_237113_((String)placeholders).m_6270_(text.m_7383_());
    }

    private static Component newLine() {
        return Component.m_237113_((String)" ");
    }
}

