/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import mod.chloeprime.aaaparticles.api.client.effekseer.EffekseerEffect;
import mod.chloeprime.aaaparticles.api.client.effekseer.TextureType;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.loader.EffekLoadException;
import mod.chloeprime.aaaparticles.client.registry.EffectDefinition;
import mod.chloeprime.aaaparticles.client.render.EffekRenderer;
import mod.chloeprime.aaaparticles.common.util.LimitlessResourceLocation;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffekAssetLoader
extends class_4080<Preparations> {
    private static EffekAssetLoader INSTANCE;
    private static final Logger LOGGER;
    private final Map<class_2960, EffectDefinition> loadedEffects = new LinkedHashMap<class_2960, EffectDefinition>();

    public static EffekAssetLoader get() {
        return INSTANCE;
    }

    @Nullable
    public EffectDefinition get(class_2960 id) {
        return this.loadedEffects.get(id);
    }

    public Set<Map.Entry<class_2960, EffectDefinition>> entries() {
        return this.loadedEffects.entrySet();
    }

    public void forEach(BiConsumer<class_2960, EffectDefinition> action) {
        this.loadedEffects.forEach(action);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<EffekseerEffect> loadEffect(class_3300 manager, class_2960 name, class_3298 efkefc) {
        try (InputStream input = efkefc.method_14482();){
            EffekseerEffect effect = new EffekseerEffect();
            boolean success = effect.load(input, 1.0f);
            if (!success) {
                LOGGER.error("Failed to load " + name);
                Optional<EffekseerEffect> optional2 = Optional.empty();
                return optional2;
            }
            for (TextureType texType : TextureType.values()) {
                int count = effect.textureCount(texType);
                this.load(manager, name, count, i -> effect.getTexturePath(i, texType), (b, len, i) -> effect.loadTexture((byte[])b, len, i, texType));
            }
            this.load(manager, name, effect.modelCount(), effect::getModelPath, effect::loadModel);
            this.load(manager, name, effect.curveCount(), effect::getCurvePath, effect::loadCurve);
            this.load(manager, name, effect.materialCount(), effect::getMaterialPath, effect::loadMaterial);
            Optional<EffekseerEffect> optional = Optional.of(effect);
            return optional;
        }
        catch (IOException ex2) {
            EffekAssetLoader.handleCheckedException(ex2);
            return Optional.empty();
        }
    }

    private void load(class_3300 manager, class_2960 name, int count, IntFunction<String> pathGetter, TriConsumer<byte[]> loadMethod) throws IOException {
        String modid = name.method_12836();
        for (int i = 0; i < count; ++i) {
            String effekAssetPath = pathGetter.apply(i);
            String mcAssetPath = ("effeks/" + effekAssetPath).replace('\\', '/').replace("//", "/");
            String fallbackMcAssetPath = ("effeks/" + name.method_12832() + "/" + effekAssetPath).replace('\\', '/').replace("//", "/");
            LimitlessResourceLocation main = new LimitlessResourceLocation(modid, mcAssetPath);
            LimitlessResourceLocation fallback = new LimitlessResourceLocation(modid, fallbackMcAssetPath);
            class_3298 resource = EffekAssetLoader.getResourceOrUseFallbackPath(manager, main, fallback).orElseThrow(() -> new FileNotFoundException("Failed to load %s or %s".formatted(new Object[]{main, fallback})));
            try (InputStream input = resource.method_14482();){
                byte[] bytes = IOUtils.toByteArray((InputStream)input);
                boolean success = loadMethod.accept(bytes, bytes.length, i);
                if (success) continue;
                String info = String.format("Failed to load effek data %s", effekAssetPath);
                LOGGER.debug(String.format("\n%s\nmc asset path is \"%s\"", info, mcAssetPath));
                throw new EffekLoadException(info);
            }
        }
    }

    private static Optional<class_3298> getResourceOrUseFallbackPath(class_3300 manager, class_2960 path, class_2960 fallback) {
        return manager.method_14486(path).or(() -> manager.method_14486(fallback));
    }

    private void unloadAll() {
        this.loadedEffects.forEach((? super K id, ? super V definition) -> definition.close());
        this.loadedEffects.clear();
    }

    @NotNull
    protected Preparations prepare(class_3300 manager, class_3695 profilerFiller) {
        return null;
    }

    private static class_2960 createEffekName(class_2960 location) {
        String filePath = location.method_12832();
        if (filePath.startsWith("effeks/")) {
            filePath = filePath.substring("effeks/".length());
        }
        if (filePath.endsWith(".efkefc") || filePath.endsWith(".efkpkg")) {
            filePath = filePath.substring(0, filePath.length() - ".efkefc".length());
        }
        return new class_2960(location.method_12836(), filePath);
    }

    protected void apply(Preparations prep_, class_3300 manager, class_3695 profilerFiller) {
        EffekRenderer.init();
        if (!NativePlatform.isRunningOnUnsupportedPlatform()) {
            Preparations prep = new Preparations();
            manager.method_14488("effeks", rl -> rl.method_12832().endsWith(".efkefc")).forEach((? super K location, ? super V resource) -> {
                class_2960 name = EffekAssetLoader.createEffekName(location);
                this.loadEffect(manager, name, (class_3298)resource).ifPresent(effect -> prep.loadedEffects.put(name, new EffectDefinition().setEffect((EffekseerEffect)effect)));
            });
            this.unloadAll();
            this.loadedEffects.putAll(prep.loadedEffects);
        }
        INSTANCE = this;
    }

    private static void handleCheckedException(Exception e) {
        throw new RuntimeException(e);
    }

    static {
        LOGGER = LogManager.getLogger((String)EffekAssetLoader.class.getSimpleName());
    }

    @FunctionalInterface
    private static interface TriConsumer<T> {
        public boolean accept(T var1, int var2, int var3);
    }

    protected static class Preparations {
        private final Map<class_2960, EffectDefinition> loadedEffects = new LinkedHashMap<class_2960, EffectDefinition>();

        protected Preparations() {
        }
    }
}

