/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.render;

import java.nio.FloatBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import mod.chloeprime.aaaparticles.AAAParticles;
import mod.chloeprime.aaaparticles.api.client.effekseer.DeviceType;
import mod.chloeprime.aaaparticles.api.client.effekseer.Effekseer;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.loader.EffekAssetLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;

public class EffekRenderer {
    private static final FloatBuffer CAMERA_TRANSFORM_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer PROJECTION_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final AtomicBoolean INIT = new AtomicBoolean();
    private static final float[] CAMERA_TRANSFORM_DATA = new float[16];
    private static final float[] PROJECTION_MATRIX_DATA = new float[16];
    private static final long[] lastDrawTimeByNanos = new long[256];

    public static void init() {
        if (INIT.compareAndExchange(false, true)) {
            return;
        }
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            AAAParticles.LOGGER.warn("AAAParticles is running un unsupported platform {}, this mod will be no-op!", (Object)NativePlatform.current());
            return;
        }
        if (Effekseer.getDeviceType() != DeviceType.OPENGL) {
            if (!Effekseer.init()) {
                throw new ExceptionInInitializerError("Failed to initialize Effekseer");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(Effekseer::terminate, "ShutdownHook Effekseer::terminate"));
        }
    }

    public static void onRenderWorldLast(float partialTick, class_4587 pose, Matrix4f projection, class_4184 camera) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        EffekRenderer.draw(ParticleEmitter.Type.WORLD, partialTick, pose, projection, camera);
    }

    public static void onRenderHand(float partialTick, class_1268 hand, class_4587 pose, Matrix4f projection, class_4184 camera) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        ParticleEmitter.Type type = switch (hand) {
            default -> throw new IncompatibleClassChangeError();
            case class_1268.field_5808 -> ParticleEmitter.Type.FIRST_PERSON_MAINHAND;
            case class_1268.field_5810 -> ParticleEmitter.Type.FIRST_PERSON_OFFHAND;
        };
        EffekRenderer.draw(type, partialTick, pose, projection, camera);
    }

    private static void draw(ParticleEmitter.Type type, float partialTick, class_4587 pose, Matrix4f projection, class_4184 camera) {
        int w = MinecraftHolder.MINECRAFT.method_22683().method_4489();
        int h = MinecraftHolder.MINECRAFT.method_22683().method_4506();
        projection.get(PROJECTION_BUFFER);
        EffekRenderer.transposeMatrix(PROJECTION_BUFFER);
        PROJECTION_BUFFER.get(PROJECTION_MATRIX_DATA);
        pose.method_22903();
        if (type == ParticleEmitter.Type.WORLD) {
            pose.method_22904(-camera.method_19326().method_10216(), -camera.method_19326().method_10214(), -camera.method_19326().method_10215());
        }
        pose.method_23760().method_23761().get(CAMERA_TRANSFORM_BUFFER);
        EffekRenderer.transposeMatrix(CAMERA_TRANSFORM_BUFFER);
        CAMERA_TRANSFORM_BUFFER.get(CAMERA_TRANSFORM_DATA);
        pose.method_22909();
        Optional.ofNullable(MinecraftHolder.MINECRAFT.field_1769.method_29362()).ifPresent(rt -> rt.method_29329(MinecraftHolder.MINECRAFT.method_1522()));
        float deltaFrames = 60.0f * EffekRenderer.getDeltaTime(type);
        float realDelta = MinecraftHolder.MINECRAFT.method_1493() ? 0.0f : deltaFrames;
        class_1921.field_25281.method_23516();
        EffekAssetLoader.get().forEach((id, inst) -> inst.draw(type, camera.method_19335(), camera.method_19326().method_46409(), w, h, CAMERA_TRANSFORM_DATA, PROJECTION_MATRIX_DATA, realDelta, partialTick));
        class_1921.field_25281.method_23518();
        CAMERA_TRANSFORM_BUFFER.clear();
        PROJECTION_BUFFER.clear();
    }

    private static void transposeMatrix(FloatBuffer m) {
        float m00 = m.get(0);
        float m01 = m.get(1);
        float m02 = m.get(2);
        float m03 = m.get(3);
        float m10 = m.get(4);
        float m11 = m.get(5);
        float m12 = m.get(6);
        float m13 = m.get(7);
        float m20 = m.get(8);
        float m21 = m.get(9);
        float m22 = m.get(10);
        float m23 = m.get(11);
        float m30 = m.get(12);
        float m31 = m.get(13);
        float m32 = m.get(14);
        float m33 = m.get(15);
        m.put(0, m00);
        m.put(1, m10);
        m.put(2, m20);
        m.put(3, m30);
        m.put(4, m01);
        m.put(5, m11);
        m.put(6, m21);
        m.put(7, m31);
        m.put(8, m02);
        m.put(9, m12);
        m.put(10, m22);
        m.put(11, m32);
        m.put(12, m03);
        m.put(13, m13);
        m.put(14, m23);
        m.put(15, m33);
    }

    private static float getDeltaTime(ParticleEmitter.Type type) {
        long now;
        long last = lastDrawTimeByNanos[type.ordinal()];
        if (last == 0L) {
            EffekRenderer.lastDrawTimeByNanos[type.ordinal()] = System.nanoTime();
            return 0.016666668f;
        }
        EffekRenderer.lastDrawTimeByNanos[type.ordinal()] = now = System.nanoTime();
        return (float)((double)(now - last) * 1.0E-9);
    }

    public static final class MinecraftHolder {
        public static final class_310 MINECRAFT = class_310.method_1551();
    }
}

