/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client;

import dev.architectury.registry.ReloadListenerRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import mod.chloeprime.aaaparticles.AAAParticles;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.common.DynamicParameter;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import mod.chloeprime.aaaparticles.client.Debug;
import mod.chloeprime.aaaparticles.client.installer.JarExtractor;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.loader.EffekAssetLoader;
import mod.chloeprime.aaaparticles.client.registry.EffectRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_746;

public class AAAParticlesClient {
    public static void init() {
        AAAParticlesClient.installNativeLibrary();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new EffekAssetLoader(), (class_2960)AAAParticles.loc("effek"));
        Debug.INSTANCE.registerDebugHooks();
    }

    public static void setup() {
    }

    private static void installNativeLibrary() {
        NativePlatform platform = NativePlatform.current();
        if (platform.isUnsupported()) {
            return;
        }
        String DLL_NAME = "EffekseerNativeForJava";
        File dll = platform.getNativeInstallPath(DLL_NAME);
        try {
            String resource = "assets/%s/%s".formatted("aaa_particles", platform.formatFileName(DLL_NAME));
            if (!dll.isFile()) {
                AAAParticles.LOGGER.info("Installing Effekseer native library at {}", (Object)dll.getCanonicalPath());
                JarExtractor.extract(resource, dll);
            } else {
                boolean updated = JarExtractor.update(resource, dll);
                if (updated) {
                    AAAParticles.LOGGER.info("Updating Effekseer native library at {}", (Object)dll.getCanonicalPath());
                } else {
                    AAAParticles.LOGGER.info("Loading Effekseer native library at {}", (Object)dll.getCanonicalPath());
                }
            }
            System.load(dll.getCanonicalPath());
        }
        catch (IOException | UnsatisfiedLinkError e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static void addParticle(class_1937 level, ParticleEmitterInfo info) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_37908() != level) {
            return;
        }
        info.spawnInWorld(level, (class_1657)player);
    }

    public static void setParam(ParticleEmitter.Type type, class_2960 effek, class_2960 emitterName, DynamicParameter[] params) {
        Optional.ofNullable(EffectRegistry.get(effek)).flatMap(mng -> mng.getNamedEmitter(type, emitterName)).ifPresent(emitter -> {
            for (DynamicParameter param : params) {
                emitter.setDynamicInput(param.index(), param.value());
            }
        });
    }

    public static void sendTrigger(ParticleEmitter.Type type, class_2960 effek, class_2960 emitterName, int[] triggers) {
        Optional.ofNullable(EffectRegistry.get(effek)).flatMap(mng -> mng.getNamedEmitter(type, emitterName)).ifPresent(emitter -> Arrays.stream(triggers).forEach(emitter::sendTrigger));
    }
}

