/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.worldgen.feature;

import com.mojang.serialization.Codec;
import elocindev.eldritch_end.registry.BlockRegistry;
import elocindev.eldritch_end.worldgen.feature.TreeConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PrimordialTreeFeature
extends Feature<TreeConfig> {
    public PrimordialTreeFeature(Codec<TreeConfig> configCodec) {
        super(configCodec);
    }

    public static boolean canBePlaced(WorldGenLevel world, BlockPos position, String type) {
        if (type == "small") {
            if (world.m_8055_(position).m_60734_() != BlockRegistry.ABYSMAL_FRONDS) {
                return false;
            }
        } else {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (world.m_8055_(position.m_7918_(x, 0, z)).m_60734_() == BlockRegistry.ABYSMAL_FRONDS) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfig> context) {
        boolean generated = false;
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        int variation = context.m_225041_().m_188503_(2) + 1;
        String type = context.m_225041_().m_188499_() ? "big" : "small";
        ResourceLocation TREE_TYPE = new ResourceLocation("eldritch_end", "primordial_tree_" + type + "/variation_" + variation);
        StructureTemplateManager structureManager = world.m_7654_().m_236738_();
        Optional template = structureManager.m_230407_(TREE_TYPE);
        if (template.isEmpty()) {
            return false;
        }
        Rotation rotation = Rotation.m_221990_((RandomSource)context.m_225041_());
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).m_163801_().m_123341_() / 2, ((StructureTemplate)template.get()).m_163801_().m_123342_() / 2, ((StructureTemplate)template.get()).m_163801_().m_123343_() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        BlockPos position = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, new BlockPos(origin.m_123341_(), origin.m_123342_(), origin.m_123343_()));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74379_(rotation).m_74385_(halfLengths).m_74392_(false);
        mutable.m_122190_((Vec3i)position).m_122184_(-halfLengths.m_123341_(), 0, -halfLengths.m_123343_());
        if (PrimordialTreeFeature.canBePlaced(world, position.m_7495_(), type)) {
            ((StructureTemplate)template.get()).m_230328_((ServerLevelAccessor)world, (BlockPos)mutable, (BlockPos)mutable, placementsettings, context.m_225041_(), 4);
            generated = true;
        }
        return generated;
    }
}

