/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.worldgen.feature;

import com.mojang.serialization.Codec;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class HasturianSpikeFeature
extends Feature<NoneFeatureConfiguration> {
    public HasturianSpikeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public static boolean canBePlaced(WorldGenLevel world, BlockPos position) {
        return world.m_8055_(position).m_60734_() == BlockRegistry.HASTURIAN_MOSS;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int l;
        int k;
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        BlockState block = BlockRegistry.SPIRE_STONE.m_49966_();
        WorldGenLevel world = context.m_159774_();
        blockPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, blockPos);
        if (!Configs.Biome.HASTURIAN_WASTES.enable_spike_generation) {
            return false;
        }
        if (random.m_188503_(100) >= Configs.Biome.HASTURIAN_WASTES.spike_generation_chance) {
            return false;
        }
        if (!HasturianSpikeFeature.canBePlaced(world, blockPos.m_7495_())) {
            return false;
        }
        if (world.m_8055_(blockPos.m_7495_()).m_60734_() == Blocks.f_50016_) {
            return false;
        }
        blockPos = blockPos.m_6625_(2);
        blockPos = blockPos.m_6630_(random.m_188503_(4));
        int i = random.m_188503_(4) + 7;
        int j = i / 4 + random.m_188503_(2);
        if (j > 1 && random.m_188503_(60) == 0) {
            blockPos = blockPos.m_6630_(10 + random.m_188503_(30));
        }
        for (k = 0; k < i; ++k) {
            float f = (1.0f - (float)k / (float)i) * (float)j;
            l = Mth.m_14167_((float)f);
            for (int m = -l; m <= l; ++m) {
                float g = (float)Mth.m_14040_((int)m) - 0.25f;
                for (int n = -l; n <= l; ++n) {
                    float h = (float)Mth.m_14040_((int)n) - 0.25f;
                    if ((m != 0 || n != 0) && g * g + h * h > f * f || (m == -l || m == l || n == -l || n == l) && random.m_188501_() > 0.75f) continue;
                    BlockState blockState = world.m_8055_(blockPos.m_7918_(m, k, n));
                    if (blockState.m_60795_() || blockState.m_60713_(BlockRegistry.HASTURIAN_MOSS) || blockState.m_60713_(BlockRegistry.HASTURIAN_GRASS)) {
                        if (random.m_188503_(100) <= Configs.Biome.HASTURIAN_WASTES.etyr_spawn_chance_per_block) {
                            this.m_5974_((LevelWriter)world, blockPos.m_7918_(m, k, n), BlockRegistry.ETYR_ORE.m_49966_());
                        } else {
                            this.m_5974_((LevelWriter)world, blockPos.m_7918_(m, k, n), block);
                        }
                    }
                    if (k == 0 || l <= 1 || !(blockState = world.m_8055_(blockPos.m_7918_(m, -k, n))).m_60795_() && !blockState.m_60713_(BlockRegistry.HASTURIAN_GRASS)) continue;
                    this.m_5974_((LevelWriter)world, blockPos.m_7918_(m, -k, n), block);
                }
            }
        }
        k = j - 1;
        if (k < 0) {
            k = 0;
        } else if (k > 1) {
            k = 1;
        }
        for (int o = -k; o <= k; ++o) {
            for (l = -k; l <= k; ++l) {
                BlockState blockState2;
                BlockPos blockPos2 = blockPos.m_7918_(o, -1, l);
                int p = 50;
                if (Math.abs(o) == 1 && Math.abs(l) == 1) {
                    p = random.m_188503_(5);
                }
                while (blockPos2.m_123342_() > 50 && ((blockState2 = world.m_8055_(blockPos2)).m_60795_() || blockState2.m_60713_(BlockRegistry.HASTURIAN_MOSS) || blockState2.m_60713_(BlockRegistry.SPIRE_STONE))) {
                    this.m_5974_((LevelWriter)world, blockPos2, block);
                    blockPos2 = blockPos2.m_7495_();
                    if (--p > 0) continue;
                    blockPos2 = blockPos2.m_6625_(random.m_188503_(5) + 1);
                    p = random.m_188503_(5);
                }
            }
        }
        return true;
    }
}

