/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.utils;

import elocindev.eldritch_end.api.CorruptionAPI;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.corruption.corruption_effect.CEEyeSpawn;
import elocindev.eldritch_end.corruption.corruption_effect.CETentacleSpawn;
import elocindev.eldritch_end.entity.ominous_eye.OminousEyeEntity;
import elocindev.eldritch_end.entity.tentacle.TentacleEntity;
import elocindev.eldritch_end.registry.EntityRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ServerUtils {
    private static CETentacleSpawn TENTACLE_CFG = Configs.Mechanics.CORRUPTION.corruption_effects.tentacle_spawn;
    private static CEEyeSpawn EYE_CFG = Configs.Mechanics.CORRUPTION.corruption_effects.ominous_eye_spawn;

    public static boolean hasValidTentacleConditions(ServerPlayer serverPlayer) {
        return CorruptionAPI.getAffectedCorruptionLevel((LivingEntity)serverPlayer) >= (double)TENTACLE_CFG.getStartingLevel() && serverPlayer.f_19797_ - serverPlayer.m_21215_() <= TENTACLE_CFG.getCombatDurationTicks() && serverPlayer.m_217043_().m_188501_() <= TENTACLE_CFG.getSpawnChance();
    }

    public static boolean hasValidEyeConditions(ServerPlayer serverPlayer) {
        return CorruptionAPI.getAffectedCorruptionLevel((LivingEntity)serverPlayer) >= (double)EYE_CFG.getStartingLevel() && serverPlayer.f_19797_ - serverPlayer.m_21215_() >= EYE_CFG.getCombatDurationTicks() && serverPlayer.m_217043_().m_188501_() <= EYE_CFG.getSpawnChance();
    }

    public static void summonTentacle(ServerPlayer serverPlayer, Level world) {
        TentacleEntity tentacle = (TentacleEntity)EntityRegistry.TENTACLE.m_20615_(world);
        if (TENTACLE_CFG.getStartingLevel() <= -1 || tentacle == null || serverPlayer == null || !serverPlayer.m_20096_()) {
            return;
        }
        tentacle.m_146884_(serverPlayer.m_20182_());
        world.m_7967_((Entity)tentacle);
        serverPlayer.m_20334_(0.0, (double)TENTACLE_CFG.getLaunchVelocity(), 0.0);
        serverPlayer.f_19864_ = true;
    }

    public static void summonOminousEye(ServerPlayer serverPlayer, Level world) {
        for (int i = 0; i <= EYE_CFG.getEyeAmount(); ++i) {
            Entity ominousEye = EntityRegistry.OMINOUS_EYE.m_20615_(world);
            if (EYE_CFG.getStartingLevel() <= -1 || ominousEye == null || serverPlayer == null) {
                return;
            }
            Vec3 pos = serverPlayer.m_20182_();
            ominousEye.m_146884_(pos.m_82520_(0.0, 3.0, 0.0));
            world.m_7967_(ominousEye);
            if (!(ominousEye instanceof OminousEyeEntity)) continue;
            OminousEyeEntity livingOminousEye = (OminousEyeEntity)ominousEye;
            livingOminousEye.m_6710_((LivingEntity)serverPlayer);
        }
    }

    public static void healthDrainCheck(MinecraftServer server) {
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            if (!(CorruptionAPI.getAffectedCorruptionLevel((LivingEntity)serverPlayer) >= (double)Configs.Mechanics.CORRUPTION.corruption_effects.madness_consumed.getStartingLevel())) continue;
            serverPlayer.m_6469_(serverPlayer.m_269291_().m_269264_(), serverPlayer.m_21233_() * Configs.Mechanics.CORRUPTION.corruption_effects.madness_consumed.getMaxHealthPerSecond());
        }
    }

    public static void tentacleSummonCheck(MinecraftServer server) {
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            if (!ServerUtils.hasValidTentacleConditions(serverPlayer)) continue;
            ServerUtils.summonTentacle(serverPlayer, serverPlayer.m_9236_());
        }
    }

    public static void ominousEyeSummonCheck(MinecraftServer server) {
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            if (!ServerUtils.hasValidEyeConditions(serverPlayer)) continue;
            ServerUtils.summonOminousEye(serverPlayer, serverPlayer.m_9236_());
        }
    }
}

