/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.item.relics;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import elocindev.eldritch_end.api.infusion.InfusableItemMaterial;
import elocindev.eldritch_end.api.infusion.InfusionAttributeHolder;
import elocindev.eldritch_end.client.particle.EldritchParticles;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.effects.Corruption;
import elocindev.eldritch_end.item.relics.base.CorruptionRelic;
import elocindev.eldritch_end.registry.AttributeRegistry;
import elocindev.eldritch_end.registry.ItemRegistry;
import elocindev.eldritch_end.registry.SoundEffectRegistry;
import elocindev.eldritch_end.worldgen.util.TextUtils;
import elocindev.necronomicon.api.text.TextAPI;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Xal
extends CorruptionRelic
implements InfusableItemMaterial {
    private final String ATTACK_PROGRESS = "attackProgress";
    private final String TARGET_X = "targetX";
    private final String TARGET_Y = "targetY";
    private final String TARGET_Z = "targetZ";
    private final int ATTACK_DURATION = 94;

    public Xal(Item.Properties settings) {
        super(settings);
    }

    private int getSurgeProgress(ItemStack stack) {
        return stack.m_41783_().m_128451_("attackProgress");
    }

    private void shadowSurge(Player player, ItemStack stack, Level world) {
        int targetX = stack.m_41783_().m_128451_("targetX");
        int targetY = stack.m_41783_().m_128451_("targetY");
        int targetZ = stack.m_41783_().m_128451_("targetZ");
        world.m_6263_((Player)null, (double)targetX, (double)targetY, (double)targetZ, SoundEffectRegistry.ORB_EVENT, player.m_5720_(), 1.0f, 1.0f);
        for (Entity entity2 : world.m_6443_(Entity.class, new AABB(new BlockPos(targetX, targetY, targetZ)).m_82377_(6.0, 3.0, 6.0), entity -> true)) {
            entity2.m_6469_(Corruption.of(world, Corruption.DAMAGE), Configs.Items.XAL.DAMAGE_PER_STRIKE);
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (stack.m_41783_() == null || entity.m_9236_().f_46443_ || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.getSurgeProgress(stack) == 43 || this.getSurgeProgress(stack) == 52 || this.getSurgeProgress(stack) == 63) {
            this.shadowSurge(player, stack, world);
        }
        if (this.getSurgeProgress(stack) < 94) {
            stack.m_41783_().m_128405_("attackProgress", this.getSurgeProgress(stack) + 1);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        MutableComponent type = TextAPI.Styles.getGradient((Component)Component.m_237115_((String)"item.eldritch_end.xal.type"), (int)1, (int)6043781, (int)9326287, (float)1.0f);
        MutableComponent ability_icon = Component.m_237119_().m_130946_("\ua996 ");
        MutableComponent ability_damage = Component.m_237119_().m_130946_(Configs.Items.XAL.DAMAGE_PER_STRIKE + " damage").m_6270_(TextUtils.Styles.DAMAGE_CORRUPTION);
        tooltip.add((Component)type.m_130948_(type.m_7383_().m_131162_(Boolean.valueOf(true))));
        tooltip.add(this.emptyLine());
        MutableComponent shadowburst = Component.m_237119_().m_130946_("Shadowburst");
        shadowburst.m_6270_(TextUtils.Styles.CORRUPTION_ABILITY);
        ability_icon.m_7220_((Component)shadowburst);
        tooltip.add((Component)ability_icon);
        MutableComponent description1 = Component.m_237115_((String)"item.eldritch_end.xal.shadowburst.1").m_6270_(TextUtils.Styles.DESCRIPTION);
        MutableComponent description2 = Component.m_237115_((String)"item.eldritch_end.xal.shadowburst.2").m_6270_(TextUtils.Styles.DESCRIPTION);
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)description1).m_7220_((Component)Component.m_237113_((String)" \ua997 ").m_7220_((Component)ability_damage)));
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)description2));
        tooltip.add(this.emptyLine());
        String appliesto = Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor && Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons ? "infusion.eldritch_end.applies_to_all" : (Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor ? "infusion.eldritch_end.applies_to_armor" : "infusion.eldritch_end.applies_to_weapons");
        tooltip.add((Component)Component.m_237115_((String)"infusion.eldritch_end.infusable").m_7220_((Component)Component.m_237115_((String)appliesto)).m_130946_(" (Tier III)").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    private Component emptyLine() {
        return Component.m_237113_((String)" ");
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        HashMultimap modifiers = HashMultimap.create((Multimap)super.m_7167_(slot));
        UUID uuid = UUID.fromString("399fe278-8564-11ee-b9d1-0242ac120002");
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            modifiers.put((Object)AttributeRegistry.CORRUPTION, (Object)new AttributeModifier(uuid, "Corruption modifier", 10.0, AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41783_() == null) {
            this.createStackNBT(itemStack);
        }
        if (itemStack.m_41783_().m_128451_("attackProgress") == 94) {
            itemStack.m_41783_().m_128405_("attackProgress", 0);
            itemStack.m_41783_().m_128405_("targetX", (int)user.m_20182_().f_82479_);
            itemStack.m_41783_().m_128405_("targetY", (int)user.m_20182_().f_82480_);
            itemStack.m_41783_().m_128405_("targetZ", (int)user.m_20182_().f_82481_);
        }
        EldritchParticles.playEffek("shadowsurge", world, user.m_20182_(), true, 0.3f).bindOnEntity((Entity)user);
        user.m_36335_().m_41524_((Item)this, Configs.Items.XAL.COOLDOWN_TICKS);
        return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
    }

    private void createStackNBT(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_("attackProgress", 0);
    }

    @Override
    public List<InfusionAttributeHolder> getInfusionAttributes() {
        return List.of(new InfusionAttributeHolder(AttributeRegistry.CORRUPTION, 35.0, InfusionAttributeHolder.Presets.CORRUPTION));
    }

    @Override
    public Item getInfusionTemplate() {
        return ItemRegistry.CORRUPTION_INFUSION_TEMPLATE;
    }

    @Override
    public boolean applyToArmor() {
        return Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor;
    }

    @Override
    public boolean applyToWeapons() {
        return Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons;
    }

    @Override
    public List<String> canSwapInfusionTo() {
        return List.of("eldritch_end:aberration_heart", "eldritch_end:aberration_limb");
    }
}

